
clear; clc; 
close all

FONT_SIZE = 13; 
SPESSORE = 2.5;

CurrentFolder = cd; 
path(path,[CurrentFolder '\Subroutines']);

LogGDP = xlsread([CurrentFolder '\Data\GDPC1.xls'],'GDP','c12:c289'); 
DATES = [1947+1/4:1/4:2020]';
DATES=DATES(1:size(LogGDP,1),1);
DATESplot = x2mdate(xlsread([CurrentFolder '\Data\GDPC1.xls'],'GDP','d12:d289'));

NamesVariables{1} = 'GDP Quarterly Growth'; 
NamesVariables{2} = 'GDP Annual Growth'; 

% Case_Frequency = 'QoQ';
Case_Frequency = 'YoY';

switch Case_Frequency
    case 'QoQ'
        D_GDP = 4*(LogGDP(2:end,1)-LogGDP(2-1:end-1,1)); 
        DATES_gr = DATES(2:end,1);
        DATESplot_gr = DATESplot(2:end,1);
    case 'YoY' 
        D_GDP = LogGDP(5:end,1)-LogGDP(1:end-4,1);
        DATES_gr = DATES(5:end,1); 
        DATESplot_gr = DATESplot(5:end,1);
end
        
    %% SPECIFY STARTING    
    InitalDate = 1947+1/4; %1948+1/4;%
    SplittingDate = 1984+2/4;
    FindInitalDate = find(DATES_gr==InitalDate);
    FindSplittingDate = find(DATES_gr==SplittingDate);
    
    OnesFirstSample = ones(size(D_GDP)); OnesFirstSample(FindSplittingDate:end,1)=NaN;
    OnesSecondSample = ones(size(D_GDP)); OnesSecondSample(1:FindSplittingDate-1,1)=NaN;
    
    %% CALCULATE BASIC STATS
    Mean_FirstSub_start48 = mean(D_GDP(1:FindSplittingDate-1));
    Std_FirstSub_start48 = std(D_GDP(1:FindSplittingDate-1));
    
    Mean_FirstSub_start60 = mean(D_GDP(FindInitalDate:FindSplittingDate-1));
    Std_FirstSub_start60 = std(D_GDP(FindInitalDate:FindSplittingDate-1));
    
    Mean_SeconfSub_start84 = mean(D_GDP(FindSplittingDate:end));
    Std_SeconfSub_start84 = std(D_GDP(FindSplittingDate:end));
    
    
DATE_DATI = datenum(floor(DATES_gr(1)),2:3:3*size(DATES_gr,1),1)';

% CISet = norminv([.025 .05 .1 .9 .95 .975],0,1);
% CISet = norminv([.05 .1 .9 .95],0,1);
CISet = [-1.64 -1 1 1.64];
% CISet = norminv([.1 .2 .8 .9],0,1);


        figure(22); 
        % subplot(2,2,1:2);
        CI_of_InterestFirst = [Mean_FirstSub_start48*ones(size(CISet)) + Std_FirstSub_start48*CISet];
        CI_of_InterestSecond = [Mean_SeconfSub_start84*ones(size(CISet)) + Std_SeconfSub_start84*CISet];
        WhatToPlot = [D_GDP OnesFirstSample*CI_of_InterestFirst OnesSecondSample*CI_of_InterestSecond];
        plot1 = plot(DATESplot_gr,WhatToPlot,'linewidth',SPESSORE-.5,'color','g','linestyle','--');
        set(plot1(1),'linewidth',SPESSORE,'color','b','linestyle','-');
        set(plot1(1+1),'linestyle',':');
        set(plot1(1+4),'linestyle',':');
        set(plot1(1+4+1),'linestyle',':');
        set(plot1(1+4+4),'linestyle',':');
        xlim([min(DATESplot_gr) max(DATESplot_gr)]);
        ylim([floor(min(WhatToPlot(:))-.2) ceil(max(WhatToPlot(:))+.2)]);
        set(gca,'Xtick',DATESplot_gr); datetick('x','yyyy','keepticks'); 
        recessionplot; datetick('x','yyyy','keeplimits');
        grid('on');
        % title('GDP Growth')
        tightfig
        % saveas(gcf,'FIGURE_GDP_TS','pdf');
        % saveas(gcf,'FIGURE_GDP_TS','tif');


